<!doctype html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title><?php echo $__env->yieldContent('page-title'); ?> - <?php echo e(setting('app_name')); ?></title>

    <link href="<?php echo e(asset('assets/css/app.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/css/fontawesome-all.min.css')); ?>" rel="stylesheet">

    <?php echo $__env->yieldContent('header-scripts'); ?>

    <?php if (\Vanguard\Plugins\Vanguard::hasHook('auth:styles')) { 
                collect(\Vanguard\Plugins\Vanguard::getHookHandlers('auth:styles'))
                    ->each(function ($hook) {
                        echo resolve($hook)->handle();
                    });
            } ?>
</head>
<body class="auth">

    <div class="d-flex justify-content-end py-2 pr-4">
        <?php echo $__env->make('partials.locale-dropdown', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>

    <div class="container">
        <?php echo $__env->yieldContent('content'); ?>
    </div>

    <script src="<?php echo e(asset('assets/js/vendor.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/as/app.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/as/btn.js')); ?>"></script>
    <?php echo $__env->yieldContent('scripts'); ?>
    <?php if (\Vanguard\Plugins\Vanguard::hasHook('auth:scripts')) { 
                collect(\Vanguard\Plugins\Vanguard::getHookHandlers('auth:scripts'))
                    ->each(function ($hook) {
                        echo resolve($hook)->handle();
                    });
            } ?>
</body>
</html>
<?php /**PATH /home/nzkxcmes/hoy.sistema2026.com/resources/views/layouts/auth.blade.php ENDPATH**/ ?>