<?php $__env->startSection('page-title', $edit ? __('Update Announcement') : __('New Announcement')); ?>
<?php $__env->startSection('page-heading', $edit ? __('Update Announcement') : __('New Announcement')); ?>

<?php $__env->startSection('breadcrumbs'); ?>
    <li class="breadcrumb-item">
        <a href="<?php echo e(route('announcements.index')); ?>"><?php echo app('translator')->get('Announcements'); ?></a>
    </li>
    <li class="breadcrumb-item active">
        <?php echo e($edit ? __('Update') : __('Create')); ?>

    </li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php echo $__env->make('partials.messages', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <form action="<?php echo e($edit ? route('announcements.update', $announcement) : route('announcements.store')); ?>"
          id="announcement-form"
          method="POST">
        <?php echo csrf_field(); ?>
        <?php if($edit): ?>
            <?php echo method_field('PUT'); ?>
        <?php endif; ?>

        <div class="row">
            <div class="col-md-6 my-4 mx-auto">
                <div class="card">
                    <h6 class="card-header">
                        <?php echo e($edit ? __('Update Announcement') : __('Create an Announcement')); ?>

                    </h6>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="title"><?php echo app('translator')->get('Title'); ?></label>
                            <input type="text"
                                   class="form-control input-solid"
                                   id="title"
                                   name="title"
                                   placeholder="<?php echo app('translator')->get('What are you announcing?'); ?>"
                                   value="<?php echo e($edit ? $announcement->title : ''); ?>">
                        </div>

                        <div class="form-group">
                            <label for="body"><?php echo app('translator')->get('Body'); ?></label>
                            <textarea
                                name="body"
                                class="form-control input-solid"
                                rows="10"
                                id="body"
                                placeholder="<?php echo app('translator')->get('Describe your announcement using markdown...'); ?>"
                            ><?php echo e($edit ? $announcement->body : ''); ?></textarea>
                        </div>

                        <?php if(! $edit): ?>
                            <div class="form-group mt-4">
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox"
                                           class="custom-control-input"
                                           name="email_notification"
                                           id="email_notification"
                                           value="1"/>

                                    <label class="custom-control-label font-weight-normal" for="email_notification">
                                        <span class="d-block"><?php echo app('translator')->get('E-Mail Notification'); ?></span>
                                        <small><?php echo app('translator')->get('Send email notification about the announcement to all users.'); ?></small>
                                    </label>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <button type="submit" class="btn btn-primary">
                            <?php echo e($edit ? __('Update Announcement') : __('Create Announcement')); ?>

                        </button>
                    </div>
                </div>
            </div>
        </div>
    </form>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <?php echo JsValidator::formRequest(\Vanguard\Announcements\Http\Requests\AnnouncementRequest::class, '#announcement-form'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/nzkxcmes/hoy.sistema2026.com/vendor/vanguardapp/announcements/src/../resources/views/add-edit.blade.php ENDPATH**/ ?>