<div class="card">
    <div class="card-body">
        <h5 class="card-title mb-1"><?php echo app('translator')->get('User Confirmation Flow'); ?></h5>

        <small class="text-muted d-block mb-4">
            <?php echo app('translator')->get('Enable/Disable the user confirmation flow for the application. When enabled, users will be set to Waiting Approval and require admin approval before becoming Active.'); ?>
        </small>

        <?php if(setting('approval.enabled')): ?>
            <form method="POST" action="<?php echo e(route('settings.auth.approval.disable')); ?>" id="auth-approval-settings-form">
                <?php echo csrf_field(); ?>
                <button type="submit"
                        class="btn btn-danger"
                        data-toggle="loader"
                        data-loading-text="<?php echo app('translator')->get('Disabling...'); ?>">
                    <?php echo app('translator')->get('Disable'); ?>
                </button>
            </form>
        <?php else: ?>
            <form method="POST" action="<?php echo e(route('settings.auth.approval.enable')); ?>" id="auth-approval-settings-form">
                <?php echo csrf_field(); ?>
                <button type="submit"
                        class="btn btn-primary"
                        data-toggle="loader"
                        data-loading-text="<?php echo app('translator')->get('Enabling...'); ?>">
                    <?php echo app('translator')->get('Enable'); ?>
                </button>
            </form>
        <?php endif; ?>
    </div>
</div>
<?php /**PATH /home/nzkxcmes/hoy.sistema2026.com/resources/views/settings/partials/confirm-flow.blade.php ENDPATH**/ ?>