<?php
    $route = 'enable';
    $needsVerification = session('tab') == '2fa' && $user->needsTwoFactorVerification();

    if ($needsVerification) {
        $route = 'verify';
    } elseif ($user->twoFactorEnabled()) {
        $route = 'disable';
    }
?>

<form action="<?php echo e(route("two-factor.{$route}")); ?>" method="POST" id="two-factor-form">
    <?php echo csrf_field(); ?>
    <input type="hidden" name="user" value="<?php echo e($user->id); ?>">
    <?php if(!$user->twoFactorEnabled() && !$needsVerification): ?>
        <button type="submit"
                class="btn btn-primary"
                data-toggle="loader"
                data-loading-text="<?php echo app('translator')->get('Enabling...'); ?>">
            <?php echo app('translator')->get('Enable'); ?>
        </button>
    <?php else: ?>
        <?php if($user->twoFactorEnabled()): ?>
            <button type="submit"
                    class="btn btn-danger mt-2"
                    data-toggle="loader"
                    data-loading-text="<?php echo app('translator')->get('Disabling...'); ?>">
                <i class="fa fa-close"></i>
                <?php echo app('translator')->get('Disable'); ?>
            </button>
        <?php else: ?>
            <h3><?php echo app('translator')->get("Please finish configuring Two-Factor authentication below."); ?></h3>
            <div class="my-3 font-medium text-sm font-weight-bold">
                <?php echo app('translator')->get("When two factor authentication is enabled, you will be prompted for a secure, random token during authentication."); ?>
                <?php echo app('translator')->get("You may retrieve this token from your phone's Authenticator application."); ?>
            </div>

            <div class="my-3 font-medium text-sm">
                <?php echo app('translator')->get("To finish enabling two factor authentication, scan the following QR code using your phone's authenticator application or enter the setup key and provide the generated OTP code."); ?>
            </div>

            <div class="my-5 d-flex align-items-center justify-content-center w-100">
                <?php echo $user->twoFactorQrCodeSvg(); ?>

            </div>

            <input type="text"
                   name="code"
                   id="code"
                   class="form-control input-solid mb-4"
                   placeholder="<?php echo app('translator')->get('Code'); ?>"
                   value="<?php echo e(old('code')); ?>">

            <button type="submit"
                    class="btn btn-primary mr-2"
                    data-toggle="loader"
                    data-loading-text="<?php echo app('translator')->get('Confirming...'); ?>">
                <i class="fa fa-close"></i>
                <?php echo app('translator')->get('Confirm'); ?>
            </button>
        <?php endif; ?>
    <?php endif; ?>
</form>
<?php /**PATH /home/nzkxcmes/hoy.sistema2026.com/resources/views/user/partials/two-factor.blade.php ENDPATH**/ ?>