@extends('layouts.app')

@section('page-title', __('My Profile'))
@section('page-heading', __('My Profile'))

@section('breadcrumbs')
    <li class="breadcrumb-item active">
        @lang('My Profile')
    </li>
@stop

@section('content')

@include('partials.messages')

@php
    $activeTab = session('tab') ?? 'details';
    $passwordChangeManager = app(\Vanguard\Support\Authorization\PasswordChangeManager::class);

    if ($user && $passwordChangeManager->isPasswordChangeForcedForUser($user)) {
        $activeTab = 'login';
    }
@endphp

@if ($passwordChangeManager->isPasswordChangeForcedForUser($user))
    <div class="alert alert-warning d-flex justify-content-between align-items-center">
        @lang('Before continuing please update your password and set a new one.')
    </div>
@endif




<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-body">
                <ul class="nav nav-tabs" id="nav-tab" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link {{ $activeTab == 'details' ? 'active' : '' }}"
                           id="details-tab"
                           data-toggle="tab"
                           href="#details"
                           role="tab"
                           aria-controls="home"
                           aria-selected="true">
                            @lang('User Details')
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {{ $activeTab == 'login' ? 'active' : '' }}"
                           id="authentication-tab"
                           data-toggle="tab"
                           href="#login-details"
                           role="tab"
                           aria-controls="home"
                           aria-selected="true">
                            @lang('Login Details')
                        </a>
                    </li>
                    @if (setting('2fa.enabled'))
                        <li class="nav-item">
                            <a class="nav-link {{ $activeTab == '2fa' ? 'active' : '' }}"
                               id="authentication-tab"
                               data-toggle="tab"
                               href="#2fa"
                               role="tab"
                               aria-controls="home"
                               aria-selected="true">
                                @lang('Two-Factor Authentication')
                            </a>
                        </li>
                    @endif
                </ul>

                <div class="tab-content mt-4" id="nav-tabContent">
                    <div class="tab-pane {{ $activeTab == 'details' ? 'show active' : '' }} fade px-2"
                         id="details"
                         role="tabpanel"
                         aria-labelledby="nav-home-tab">
                        <form action="{{ route('profile.update.details') }}" method="POST" id="details-form">
                            @method('PUT')
                            @csrf
                            @include('user.partials.details', ['profile' => true])
                        </form>
                    </div>

                    <div class="tab-pane {{ $activeTab == 'login' ? 'show active' : '' }} fade px-2"
                         id="login-details"
                         role="tabpanel"
                         aria-labelledby="nav-profile-tab">
                        <form action="{{ route('profile.update.login-details') }}"
                              method="POST"
                              id="login-details-form">
                            @method('PUT')
                            @csrf
                            @include('user.partials.auth', ['profile' => true])
                        </form>
                    </div>

                    @if (setting('2fa.enabled'))
                        <div class="tab-pane {{ $activeTab == '2fa' ? 'show active' : '' }} fade px-2"
                             id="2fa"
                             role="tabpanel"
                             aria-labelledby="nav-profile-tab"
                        >
                            @include('user.partials.two-factor')
                        </div>
                    @endif
                </div>

            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card">
            <div class="card-body">
                <form action="{{ route("profile.update.avatar") }}"
                      method="POST"
                      id="avatar-form"
                      enctype="multipart/form-data">
                    @csrf
                    @include('user.partials.avatar', ['updateUrl' => route('profile.update.avatar-external')])
                </form>
            </div>
        </div>
    </div>
</div>

@stop

@section('scripts')
    <script src="{{ asset('assets/js/as/btn.js') }}"></script>
    <script src="{{ asset('assets/js/as/profile.js') }}"></script>
    {!! JsValidator::formRequest('Vanguard\Http\Requests\User\UpdateDetailsRequest', '#details-form') !!}
    {!! JsValidator::formRequest('Vanguard\Http\Requests\User\UpdateProfileLoginDetailsRequest', '#login-details-form') !!}

    @if (setting('2fa.enabled'))
        {!! JsValidator::formRequest('Vanguard\Http\Requests\TwoFactor\EnableTwoFactorRequest', '#two-factor-form') !!}
    @endif
@stop
