@extends('layouts.app1')

@section('page-title', __('My Profile'))
@section('page-heading', __('My Profile'))

@section('breadcrumbs')
    <li class="breadcrumb-item active">
        @lang('My Profile')
    </li>
@stop

@section('styles')
    <style>
        /* Contenedor principal mejorado */
        .profile-container {
            margin-top: 20px;
            padding: 0;
            width: 100%;
            position: relative;
        }

        /* Menú de pestañas moderno */
        .nav-tabs {
            background-color: #f8f9fa;
            padding: 0 15px;
            border-bottom: none;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
            display: flex;
            flex-wrap: wrap;
            z-index: 1000;
            position: relative;
        }

        /* Items del menú mejorados */
        .nav-tabs .nav-item {
            margin-right: 5px;
            margin-bottom: 5px;
        }

        .nav-tabs .nav-link {
            color: #495057;
            border: none;
            border-radius: 4px 4px 0 0;
            padding: 10px 15px;
            font-size: 14px;
            font-weight: 500;
            transition: all 0.3s ease;
            margin-bottom: 0;
            display: flex;
            align-items: center;
            white-space: nowrap;
        }

        .nav-tabs .nav-link i {
            margin-right: 8px;
            font-size: 14px;
            width: 18px;
            text-align: center;
        }

        /* Efecto hover moderno */
        .nav-tabs .nav-link:hover {
            background-color: #e9ecef;
            color: #0056b3;
        }

        /* Pestaña activa - estilo moderno */
        .nav-tabs .nav-link.active {
            color: #fff;
            background-color: #28a745;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            border: none;
            position: relative;
            font-weight: 600;
        }

        .nav-tabs .nav-link.active:after {
            content: '';
            position: absolute;
            bottom: -5px;
            left: 0;
            width: 100%;
            height: 5px;
            background-color: #06471d;
        }

        /* Contenedor iframe ajustado */
        .iframe-container {
            position: fixed;
            top: 120px;
            left: 0;
            right: 0;
            bottom: 0;
            margin: 0;
            padding: 0;
            overflow: hidden;
            background: #fff;
            border-radius: 0 0 4px 4px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
            display: none;
            z-index: 10;
        }
        
        .iframe-container.active {
            display: block;
        }
        
        .iframe-container iframe {
            width: 100%;
            height: 100%;
            border: none;
            display: block;
        }

        /* Contenido de las pestañas */
        .tab-content {
            padding: 25px;
            background: #fff;
            min-height: calc(100vh - 120px);
            border-radius: 0 0 4px 4px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
            position: relative;
            z-index: 5;
        }

        /* Ajuste para el menú superior */
        body {
            padding-top: 60px;
        }
        
        /* Scroll horizontal para muchos botones */
        .tabs-scroll {
            overflow-x: auto;
            white-space: nowrap;
            -webkit-overflow-scrolling: touch;
        }
        
        .tabs-scroll::-webkit-scrollbar {
            height: 6px;
        }
        
        .tabs-scroll::-webkit-scrollbar-thumb {
            background: #ddd;
            border-radius: 3px;
        }
        
        /* Estilo para iframes locales */
        .local-iframe {
            width: 100%;
            height: calc(100vh - 180px);
            border: none;
            margin-top: 20px;
        }
    </style>
@stop

@section('content')
    @include('partials.messages')

    @php
        $activeTab = session('tab') ?? 'custom';
        $passwordChangeManager = app(\Vanguard\Support\Authorization\PasswordChangeManager::class);

        if ($user && $passwordChangeManager->isPasswordChangeForcedForUser($user)) {
            $activeTab = 'login';
        }
    @endphp

    @if ($passwordChangeManager->isPasswordChangeForcedForUser($user))
        <div class="alert alert-warning d-flex justify-content-between align-items-center">
            @lang('Before continuing please update your password and set a new one.')
        </div>
    @endif

    <div class="profile-container">
        <div class="tabs-scroll">
            <ul class="nav nav-tabs" id="nav-tab" role="tablist">
                <!-- Botón 1 -->
                <li class="nav-item">
                    <a class="nav-link" data-tab="custom1" data-src="/deepseek_html_20250609_e17026.html" role="tab">
                       <i class="fas fa-file-code"></i> @lang('Archivo 1')
                    </a>
                </li>
                
                <!-- Botón 2 -->
                <li class="nav-item">
                    <a class="nav-link" data-tab="custom2" data-src="/consulta.php" role="tab">
                       <i class="fas fa-file-code"></i> @lang('Archivo 2')
                    </a>
                </li>
                
                <!-- Botón 3 -->
                <li class="nav-item">
                    <a class="nav-link" data-tab="custom3" data-src="/archivo3.php" role="tab">
                       <i class="fas fa-file-code"></i> @lang('Archivo 3')
                    </a>
                </li>
                
                <!-- Botón 4 -->
                <li class="nav-item">
                    <a class="nav-link" data-tab="custom4" data-src="/archivo4.php" role="tab">
                       <i class="fas fa-file-code"></i> @lang('Archivo 4')
                    </a>
                </li>
                
                <!-- Botón 5 -->
                <li class="nav-item">
                    <a class="nav-link" data-tab="custom5" data-src="/archivo5.php" role="tab">
                       <i class="fas fa-file-code"></i> @lang('Archivo 5')
                    </a>
                </li>
                
                <!-- Botón 6 -->
                <li class="nav-item">
                    <a class="nav-link" data-tab="custom6" data-src="/archivo6.php" role="tab">
                       <i class="fas fa-file-code"></i> @lang('Archivo 6')
                    </a>
                </li>
                
                <!-- Botón 7 -->
                <li class="nav-item">
                    <a class="nav-link" data-tab="custom7" data-src="/archivo7.php" role="tab">
                       <i class="fas fa-file-code"></i> @lang('Archivo 7')
                    </a>
                </li>
                
                <!-- Botón 8 -->
                <li class="nav-item">
                    <a class="nav-link" data-tab="custom8" data-src="/archivo8.php" role="tab">
                       <i class="fas fa-file-code"></i> @lang('Archivo 8')
                    </a>
                </li>
                
                <!-- Botón 9 -->
                <li class="nav-item">
                    <a class="nav-link" data-tab="custom9" data-src="/archivo9.php" role="tab">
                       <i class="fas fa-file-code"></i> @lang('Archivo 9')
                    </a>
                </li>
                
                <!-- Botón 10 -->
                <li class="nav-item">
                    <a class="nav-link" data-tab="custom10" data-src="/archivo10.php" role="tab">
                       <i class="fas fa-file-code"></i> @lang('Archivo 10')
                    </a>
                </li>
                
                <!-- Botón 11 -->
                <li class="nav-item">
                    <a class="nav-link" data-tab="custom11" data-src="/archivo11.php" role="tab">
                       <i class="fas fa-file-code"></i> @lang('Archivo 11')
                    </a>
                </li>
                
                <!-- Botón 12 -->
                <li class="nav-item">
                    <a class="nav-link" data-tab="custom12" data-src="/archivo12.php" role="tab">
                       <i class="fas fa-file-code"></i> @lang('Archivo 12')
                    </a>
                </li>
                
                <!-- Botón 13 -->
                <li class="nav-item">
                    <a class="nav-link" data-tab="custom13" data-src="/archivo13.php" role="tab">
                       <i class="fas fa-file-code"></i> @lang('Archivo 13')
                    </a>
                </li>
                
                <!-- Botón 14 -->
                <li class="nav-item">
                    <a class="nav-link" data-tab="custom14" data-src="/archivo14.php" role="tab">
                       <i class="fas fa-file-code"></i> @lang('Archivo 14')
                    </a>
                </li>
                
                <!-- Botón 15 -->
                <li class="nav-item">
                    <a class="nav-link" data-tab="custom15" data-src="/archivo15.php" role="tab">
                       <i class="fas fa-file-code"></i> @lang('Archivo 15')
                    </a>
                </li>
                
                <!-- Botón 16 -->
                <li class="nav-item">
                    <a class="nav-link" data-tab="custom16" data-src="/archivo16.php" role="tab">
                       <i class="fas fa-file-code"></i> @lang('Archivo 16')
                    </a>
                </li>
                
                <!-- Botón 17 -->
                <li class="nav-item">
                    <a class="nav-link" data-tab="custom17" data-src="/archivo17.php" role="tab">
                       <i class="fas fa-file-code"></i> @lang('Archivo 17')
                    </a>
                </li>
                
                <!-- Botón 18 -->
                <li class="nav-item">
                    <a class="nav-link" data-tab="custom18" data-src="/archivo18.php" role="tab">
                       <i class="fas fa-file-code"></i> @lang('Archivo 18')
                    </a>
                </li>
                
                <!-- Botón 19 -->
                <li class="nav-item">
                    <a class="nav-link" data-tab="custom19" data-src="/archivo19.php" role="tab">
                       <i class="fas fa-file-code"></i> @lang('Archivo 19')
                    </a>
                </li>
                
                <!-- Botón 20 -->
                <li class="nav-item">
                    <a class="nav-link" data-tab="custom20" data-src="/archivo20.php" role="tab">
                       <i class="fas fa-file-code"></i> @lang('Archivo 20')
                    </a>
                </li>
                
                <!-- Botón 21 -->
                <li class="nav-item">
                    <a class="nav-link" data-tab="custom21" data-src="/archivo21.php" role="tab">
                       <i class="fas fa-file-code"></i> @lang('Archivo 21')
                    </a>
                </li>
                
                <!-- Botón 22 -->
                <li class="nav-item">
                    <a class="nav-link" data-tab="custom22" data-src="/archivo22.php" role="tab">
                       <i class="fas fa-file-code"></i> @lang('Archivo 22')
                    </a>
                </li>
                
                <!-- Botón 23 -->
                <li class="nav-item">
                    <a class="nav-link" data-tab="custom23" data-src="/archivo23.php" role="tab">
                       <i class="fas fa-file-code"></i> @lang('Archivo 23')
                    </a>
                </li>
                
                <!-- Botón 24 -->
                <li class="nav-item">
                    <a class="nav-link" data-tab="custom24" data-src="/archivo24.php" role="tab">
                       <i class="fas fa-file-code"></i> @lang('Archivo 24')
                    </a>
                </li>
                
                <!-- Botón 25 -->
                <li class="nav-item">
                    <a class="nav-link" data-tab="custom25" data-src="/archivo25.php" role="tab">
                       <i class="fas fa-file-code"></i> @lang('Archivo 25')
                    </a>
                </li>
                
                <!-- Botones originales para datos de usuario -->
                <li class="nav-item">
                    <a class="nav-link {{ $activeTab == 'details' ? 'active' : '' }}"
                       data-tab="details" role="tab">
                       <i class="fas fa-user-edit"></i> @lang('Datos Usuario')
                    </a>
                </li>
                
                <li class="nav-item">
                    <a class="nav-link {{ $activeTab == 'login' ? 'active' : '' }}"
                       data-tab="login-details" role="tab">
                       <i class="fas fa-key"></i> @lang('Seguridad')
                    </a>
                </li>
                
                @if (setting('2fa.enabled'))
                    <li class="nav-item">
                        <a class="nav-link {{ $activeTab == '2fa' ? 'active' : '' }}"
                           data-tab="2fa" role="tab">
                           <i class="fas fa-lock"></i> @lang('Autenticación')
                        </a>
                    </li>
                @endif
            </ul>
        </div>

        <div class="tab-content">
            <!-- Contenido de las pestañas se mantiene igual -->
            <div class="tab-pane {{ $activeTab == 'details' ? 'show active' : '' }} fade"
                 id="details" role="tabpanel">
                <form action="{{ route('profile.update.details') }}" method="POST" id="details-form">
                    @method('PUT')
                    @csrf
                    @include('user.partials.details', ['profile' => true])
                </form>
            </div>

            <div class="tab-pane {{ $activeTab == 'login' ? 'show active' : '' }} fade"
                 id="login-details" role="tabpanel">
                <form action="{{ route('profile.update.login-details') }}"
                      method="POST" id="login-details-form">
                    @method('PUT')
                    @csrf
                    @include('user.partials.auth', ['profile' => true])
                </form>
            </div>

            @if (setting('2fa.enabled'))
                <div class="tab-pane {{ $activeTab == '2fa' ? 'show active' : '' }} fade"
                     id="2fa" role="tabpanel">
                    @include('user.partials.two-factor')
                </div>
            @endif

            <!-- Iframes para los 25 archivos PHP locales -->
            <div class="iframe-container" id="iframe-custom1">
                <iframe class="local-iframe" src="" title="Archivo 1"></iframe>
            </div>
            <div class="iframe-container" id="iframe-custom2">
                <iframe class="local-iframe" src="" title="Archivo 2"></iframe>
            </div>
            <div class="iframe-container" id="iframe-custom3">
                <iframe class="local-iframe" src="" title="Archivo 3"></iframe>
            </div>
            <div class="iframe-container" id="iframe-custom4">
                <iframe class="local-iframe" src="" title="Archivo 4"></iframe>
            </div>
            <div class="iframe-container" id="iframe-custom5">
                <iframe class="local-iframe" src="" title="Archivo 5"></iframe>
            </div>
            <div class="iframe-container" id="iframe-custom6">
                <iframe class="local-iframe" src="" title="Archivo 6"></iframe>
            </div>
            <div class="iframe-container" id="iframe-custom7">
                <iframe class="local-iframe" src="" title="Archivo 7"></iframe>
            </div>
            <div class="iframe-container" id="iframe-custom8">
                <iframe class="local-iframe" src="" title="Archivo 8"></iframe>
            </div>
            <div class="iframe-container" id="iframe-custom9">
                <iframe class="local-iframe" src="" title="Archivo 9"></iframe>
            </div>
            <div class="iframe-container" id="iframe-custom10">
                <iframe class="local-iframe" src="" title="Archivo 10"></iframe>
            </div>
            <div class="iframe-container" id="iframe-custom11">
                <iframe class="local-iframe" src="" title="Archivo 11"></iframe>
            </div>
            <div class="iframe-container" id="iframe-custom12">
                <iframe class="local-iframe" src="" title="Archivo 12"></iframe>
            </div>
            <div class="iframe-container" id="iframe-custom13">
                <iframe class="local-iframe" src="" title="Archivo 13"></iframe>
            </div>
            <div class="iframe-container" id="iframe-custom14">
                <iframe class="local-iframe" src="" title="Archivo 14"></iframe>
            </div>
            <div class="iframe-container" id="iframe-custom15">
                <iframe class="local-iframe" src="" title="Archivo 15"></iframe>
            </div>
            <div class="iframe-container" id="iframe-custom16">
                <iframe class="local-iframe" src="" title="Archivo 16"></iframe>
            </div>
            <div class="iframe-container" id="iframe-custom17">
                <iframe class="local-iframe" src="" title="Archivo 17"></iframe>
            </div>
            <div class="iframe-container" id="iframe-custom18">
                <iframe class="local-iframe" src="" title="Archivo 18"></iframe>
            </div>
            <div class="iframe-container" id="iframe-custom19">
                <iframe class="local-iframe" src="" title="Archivo 19"></iframe>
            </div>
            <div class="iframe-container" id="iframe-custom20">
                <iframe class="local-iframe" src="" title="Archivo 20"></iframe>
            </div>
            <div class="iframe-container" id="iframe-custom21">
                <iframe class="local-iframe" src="" title="Archivo 21"></iframe>
            </div>
            <div class="iframe-container" id="iframe-custom22">
                <iframe class="local-iframe" src="" title="Archivo 22"></iframe>
            </div>
            <div class="iframe-container" id="iframe-custom23">
                <iframe class="local-iframe" src="" title="Archivo 23"></iframe>
            </div>
            <div class="iframe-container" id="iframe-custom24">
                <iframe class="local-iframe" src="" title="Archivo 24"></iframe>
            </div>
            <div class="iframe-container" id="iframe-custom25">
                <iframe class="local-iframe" src="" title="Archivo 25"></iframe>
            </div>
        </div>
    </div>
@stop

@section('scripts')
    <script>
        // Almacenar el estado de las pestañas
        const tabState = {};
        
        document.addEventListener('DOMContentLoaded', function() {
            // Inicializar el estado de todas las pestañas
            document.querySelectorAll('a[data-tab]').forEach(tab => {
                const tabId = tab.getAttribute('data-tab');
                tabState[tabId] = {
                    loaded: false,
                    src: tab.getAttribute('data-src') || '',
                    active: tab.classList.contains('active')
                };
            });

            // Control de tabs con iframes
            document.querySelectorAll('a[data-tab]').forEach(tab => {
                tab.addEventListener('click', function(e) {
                    e.preventDefault();
                    e.stopImmediatePropagation();
                    
                    const targetId = this.getAttribute('data-tab');
                    const iframeSrc = this.getAttribute('data-src');
                    
                    // Actualizar estado de la pestaña
                    tabState[targetId].active = true;
                    
                    // Ocultar todos los iframes primero
                    document.querySelectorAll('.iframe-container').forEach(iframe => {
                        iframe.classList.remove('active');
                    });
                    
                    // Ocultar todos los paneles de contenido
                    document.querySelectorAll('.tab-pane').forEach(pane => {
                        pane.classList.remove('show', 'active');
                    });
                    
                    // Cambiar pestañas
                    document.querySelectorAll('.nav-link').forEach(link => {
                        link.classList.remove('active');
                        const linkTabId = link.getAttribute('data-tab');
                        if (linkTabId) tabState[linkTabId].active = false;
                    });
                    this.classList.add('active');
                    
                    // Manejar iframes
                    if (iframeSrc) {
                        const iframeContainer = document.getElementById(`iframe-${targetId}`);
                        const iframe = iframeContainer.querySelector('iframe');
                        
                        // Solo cargar el src si no está ya cargado para evitar recargas
                        if (!tabState[targetId].loaded && iframeSrc) {
                            iframe.src = iframeSrc;
                            tabState[targetId].loaded = true;
                        }
                        
                        iframeContainer.classList.add('active');
                    } else {
                        // Mostrar contenido normal si no es un iframe
                        document.getElementById(targetId).classList.add('show', 'active');
                    }
                    
                    // Ajustar el iframe después de cambiar
                    setTimeout(resizeIframe, 100);
                    
                    return false;
                });
            });
            
            // Ajustar altura del iframe dinámicamente
            function resizeIframe() {
                const headerHeight = document.querySelector('.navbar').offsetHeight;
                const tabsHeight = document.querySelector('.nav-tabs').offsetHeight;
                const iframeContainers = document.querySelectorAll('.iframe-container');
                
                iframeContainers.forEach(container => {
                    container.style.top = `${headerHeight + tabsHeight}px`;
                    container.style.height = `${window.innerHeight - headerHeight - tabsHeight}px`;
                });
                
                // Ajustar también iframes locales
                document.querySelectorAll('.local-iframe').forEach(iframe => {
                    iframe.style.height = `${window.innerHeight - headerHeight - tabsHeight - 60}px`;
                });
            }
            
            // Ejecutar al cargar y al redimensionar
            resizeIframe();
            window.addEventListener('resize', resizeIframe);
            
            // Forzar redimensionamiento cuando se muestran elementos ocultos
            const observer = new MutationObserver(function(mutations) {
                resizeIframe();
            });
            
            observer.observe(document.body, {
                attributes: true,
                childList: true,
                subtree: true,
                attributeFilter: ['style', 'class']
            });
            
            // Precargar la pestaña activa inicial
            const initialActiveTab = document.querySelector('.nav-link.active');
            if (initialActiveTab) {
                initialActiveTab.click();
            }
        });
        
        // Función para recargar una pestaña específica
        function reloadTab(tabId) {
            if (tabState[tabId]) {
                tabState[tabId].loaded = false;
                const tabLink = document.querySelector(`a[data-tab="${tabId}"]`);
                if (tabLink) tabLink.click();
            }
        }
    </script>
@stop  