<!doctype html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('page-title') - {{ setting('app_name') }}</title>

    <link rel="apple-touch-icon-precomposed" sizes="144x144" href="{{ url('assets/img/icons/apple-touch-icon-144x144.png') }}" />
    <link rel="apple-touch-icon-precomposed" sizes="152x152" href="{{ url('assets/img/icons/apple-touch-icon-152x152.png') }}" />
    <link rel="icon" type="image/png" href="{{ url('assets/img/icons/favicon-32x32.png') }}" sizes="32x32" />
    <link rel="icon" type="image/png" href="{{ url('assets/img/icons/favicon-16x16.png') }}" sizes="16x16" />
    <meta name="application-name" content="{{ setting('app_name') }}"/>
    <meta name="msapplication-TileColor" content="#FFFFFF" />
    <meta name="msapplication-TileImage" content="{{ url('assets/img/icons/mstile-144x144.png') }}" />

    <link media="all" type="text/css" rel="stylesheet" href="{{ url(mix('assets/css/vendor.css')) }}">
    <link media="all" type="text/css" rel="stylesheet" href="{{ url(mix('assets/css/app.css')) }}">

    <style>
        html, body {
            margin: 0;
            padding: 0;
            height: 100%;
        }
        .content-page {
            margin-left: 5px !important;
            margin-right: 5px !important;
            margin-top: 0 !important;
            margin-bottom: 0 !important;
            padding: 0 !important;
            width: calc(100% - 10px);
            min-height: calc(100vh - 56px); /* Resta la altura del navbar */
        }
        main[role="main"] {
            padding: 0 !important;
            height: 100%;
        }
        
        /* Estilos para el menú aumentado */
        .navbar-nav .nav-link {
            font-size: 1.1rem !important;
            padding: 0.75rem 1.25rem !important;
        }
        .navbar-brand img {
            height: 40px !important;
        }
        .dropdown-menu {
            font-size: 1.05rem !important;
        }
        
        /* Prevenir scroll no deseado en tabs */
        .tab-content {
            overflow: hidden !important;
        }
    </style>

    @yield('styles')
    @hook('app:styles')
</head>
<body>
    @include('partials.navbar')

    <div class="content-page">
        <main role="main">
            @yield('content')
        </main>
    </div>

    <script src="{{ url(mix('assets/js/vendor.js')) }}"></script>
    <script src="{{ url('assets/js/as/app.js') }}"></script>

    <script>
        // Solución definitiva para tabs sin scroll
        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('.nav-tabs a[data-toggle="tab"]').forEach(tab => {
                tab.addEventListener('click', function(e) {
                    e.preventDefault();
                    e.stopImmediatePropagation();
                    
                    const target = this.getAttribute('href');
                    if (target) {
                        // Deshabilitar scroll temporalmente
                        const originalStyle = document.body.style.overflow;
                        document.body.style.overflow = 'hidden';
                        
                        $(this).tab('show');
                        
                        // Restaurar scroll después de la transición
                        setTimeout(() => {
                            document.body.style.overflow = originalStyle;
                        }, 350);
                    }
                    return false;
                });
            });
        });
    </script>

    @yield('scripts')
    @hook('app:scripts')
</body>
</html>
