<?php

namespace Vanguard\Support;

class Locale
{
    public const AVAILABLE_LOCALES = ['es',];

    public static function flagUrl(string $locale): ?string
    {
        return match ($locale) {
            'es' => url('/flags/ES.png'),
            
            default => null,
        };
    }

    public static function validateLocale(string $locale): bool
    {
        return in_array($locale, self::AVAILABLE_LOCALES);
    }
}
