<?php

namespace Vanguard\Listeners\Approve;

use Mail;
use Vanguard\Events\User\Approved;

class SendApprovedNotification
{
    public function __construct()
    {
    }

    public function handle(Approved $event): void
    {
        if (! setting('approval.enabled')) {
            return;
        }

        Mail::to($event->getApprovedUser())->send(new \Vanguard\Mail\UserApproved());
    }
}
